<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteVenta($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idventas'])) {
            getVentaById($conn, $_GET['idventas']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idlocal']) && isset($_GET['idcaja'])) {
            getPagos($conn, $_GET['idlocal'], $_GET['idcaja']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idu'])) {
            getVentas($conn, $_GET['idu']);
        } 
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateVenta($conn);
                break;
            case 'agregar':
                createVenta($conn);
                break;
            case 'cerrar':
                cerrarVenta($conn);
                break;
            case 'pagar':
                pagarVenta($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteVenta($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getVentas($conn, $idu) {
    $sql = "SELECT 
        v.idventas, 
        v.idlocal, 
        v.idusuario, 
        v.fecha, 
        v.idcliente, 
        v.monto,
        v.estado,
        v.fpago,
        c.razon AS razon
    FROM 
        ventas v
    JOIN 
        cliente c ON v.idcliente = c.idcliente
    WHERE
        v.idusuario = ?
    ORDER BY 
        v.idventas DESC;";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idu);
    $stmt->execute();
    $result = $stmt->get_result();

    $ventas = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $ventas[] = $row;  
        }

        echo json_encode($ventas);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron ventas"));
    }
}

function getPagos($conn, $idlocal, $idcaja) {
    $sql = "SELECT 
        v.idventas, 
        v.idlocal, 
        v.idusuario, 
        v.fecha, 
        v.idcliente, 
        v.monto,
        v.estado,
        v.fpago,
        v.operacion,
        v.idcaja,
        c.razon AS razon
    FROM 
        ventas v
    JOIN 
        cliente c ON v.idcliente = c.idcliente
    WHERE
        v.idlocal = ? and v.estado != 'Abierto'
    ORDER BY 
        v.idventas DESC;";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idlocal);
    $stmt->execute();
    $result = $stmt->get_result();

    $ventas = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $ventas[] = $row;  
        }

        echo json_encode($ventas);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron ventas"));
    }
}

function getVentaById($conn, $idventas) {
    $sql = "
        SELECT 
            v.idventas, 
            v.idlocal, 
            v.idusuario, 
            v.fecha, 
            v.idcliente, 
            v.monto, 
            v.estado, 
            v.fpago, 
            a.local AS local, 
            u.usuario AS usuario, 
            c.razon AS cliente,
            c.celular AS celular
        FROM 
            ventas v
        JOIN 
            alocal a ON v.idlocal = a.idlocal
        JOIN 
            auser u ON v.idusuario = u.idusuario
        JOIN 
            cliente c ON v.idcliente = c.idcliente
        WHERE 
            v.idventas = ?
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idventas);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $ventas = [];
        while ($row = $result->fetch_assoc()) {
            $ventas[] = $row; // Agrega cada registro al array
        }
        echo json_encode($ventas);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron ventas"));
    }

    $stmt->close();
}


function createVenta($conn) {
    if (isset($_POST['idlocal']) && isset($_POST['idusuario']) && isset($_POST['fecha']) && isset($_POST['idcliente']) && isset($_POST['monto']) && isset($_POST['estado'])) {
        $idlocal = $_POST['idlocal'];
        $idusuario = $_POST['idusuario'];
        $fecha = $_POST['fecha'];
        $idcliente = $_POST['idcliente'];
        $monto = $_POST['monto'];
        $estado = $_POST['estado'];
        $fpago = $_POST['fpago'];

        $sql = "INSERT INTO ventas (idlocal, idusuario, fecha, idcliente, monto, estado, fpago) 
                VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iisidss", $idlocal, $idusuario, $fecha, $idcliente, $monto, $estado, $fpago);
        
        if ($stmt->execute()) {
            $idventas = $conn->insert_id;
            echo json_encode(['idventas' => $idventas]);
        } else {
            error_log($stmt->error); 
            echo json_encode(array("mensaje" => "Error al crear venta: " . $stmt->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateVenta($conn) {
    if (isset($_POST['idventas']) && isset($_POST['idlocal']) && isset($_POST['idusuario']) && isset($_POST['fecha']) && isset($_POST['idcliente']) && isset($_POST['monto']) && isset($_POST['estado'])) {
        $idventas = $_POST['idventas'];
        $idlocal = $_POST['idlocal'];
        $idusuario = $_POST['idusuario'];
        $fecha = $_POST['fecha'];
        $idcliente = $_POST['idcliente'];
        $monto = $_POST['monto'];
        $estado = $_POST['estado'];
        $fpago = $_POST['fpago'];

        $stmt = $conn->prepare("UPDATE ventas SET idlocal=?, idusuario=?, fecha=?, idcliente=?, monto=?, estado=?, fpago=? WHERE idventas=?");
        $stmt->bind_param("iisidssi", $idlocal, $idusuario, $fecha, $idcliente, $monto, $estado, $fpago, $idventas);

        if ($stmt->execute()) {
            echo "Venta actualizada exitosamente";
        } else {
            echo "Error al actualizar venta: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}


function pagarVenta($conn) {
    if (isset($_POST['idventas']) && isset($_POST['idlocal']) && isset($_POST['idusuario']) && isset($_POST['fecha']) && isset($_POST['idcliente']) && isset($_POST['monto']) && isset($_POST['estado']) && isset($_POST['fpago']) && isset($_POST['idcaja'])) {
        $idventas = $_POST['idventas'];
        $idlocal = $_POST['idlocal'];
        $idusuario = $_POST['idusuario'];
        $fecha = $_POST['fecha'];
        $idcliente = $_POST['idcliente'];
        $monto = $_POST['monto'];
        $estado = $_POST['estado'];
        $fpago = $_POST['fpago'];
        $operacion = $_POST['operacion'];
        $idcaja = $_POST['idcaja'];
        $idusuario_p = $_POST['idusuario_p'];

        // Actualizar la tabla ventas
        $stmt = $conn->prepare("UPDATE ventas SET idlocal=?, idusuario=?, fecha=?, idcliente=?, monto=?, estado=?, fpago=?, operacion =?, idcaja=?, idusuario_p=? WHERE idventas=?");
        $stmt->bind_param("iisidsssiii", $idlocal, $idusuario, $fecha, $idcliente, $monto, $estado, $fpago, $operacion, $idcaja, $idusuario_p, $idventas);

        if ($stmt->execute()) {
            // Actualizar la tabla caja según la forma de pago
            $sql_caja = "UPDATE caja SET ";
            switch ($fpago) {
                case 'Efectivo':
                    $sql_caja .= "efectivo = efectivo + ?";
                    break;
                case 'Yape':
                    $sql_caja .= "yape = yape + ?";
                    break;
                case 'Plin':
                    $sql_caja .= "plin = plin + ?";
                    break;
                case 'Deposito':
                    $sql_caja .= "deposito = deposito + ?";
                    break;
                case 'Otros':
                    $sql_caja .= "otros = otros + ?";
                    break;
                default:
                    echo json_encode(array("mensaje" => "Forma de pago no válida."));
                    $stmt->close();
                    return; // Salir de la función si la forma de pago no es válida
            }

            $sql_caja .= ", total = total + ? WHERE idcaja = ?";
            $stmt_caja = $conn->prepare($sql_caja);
            $stmt_caja->bind_param("ddi", $monto, $monto, $idcaja); // Usar "d" para double (monto)

            if ($stmt_caja->execute()) {
                echo json_encode(array("mensaje" => "Pago exitoso y caja actualizada."));
            } else {
                echo json_encode(array("mensaje" => "Error al actualizar caja: " . $stmt_caja->error));
            }

            $stmt_caja->close();

        } else {
            echo json_encode(array("mensaje" => "Error al actualizar venta: " . $stmt->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}


function cerrarVenta($conn) {
    if (isset($_POST['idventas'])) {
        $idventas = $_POST['idventas'];

        // Obtener datos de la tabla ventas
        $stmtVenta = $conn->prepare("SELECT idlocal, idusuario, fecha, idcliente, monto FROM ventas WHERE idventas = ?");
        $stmtVenta->bind_param("i", $idventas);
        $stmtVenta->execute();
        $resultVenta = $stmtVenta->get_result();

        if ($resultVenta->num_rows > 0) {
            $venta = $resultVenta->fetch_assoc();
            $idlocal = $venta['idlocal'];
            $fecha = $venta['fecha'];
            $idusuario = $venta['idusuario'];
            $tipo = "Venta";
            $ingsal = "S"; // Salida

            // Actualizar el estado de la venta
            $stmtUpdateVenta = $conn->prepare("UPDATE ventas SET estado=? WHERE idventas=?");
            $estado = "Cerrado";
            $stmtUpdateVenta->bind_param("si", $estado, $idventas);

            if ($stmtUpdateVenta->execute()) {
                // Obtener detalles de la venta
                $stmtDetVenta = $conn->prepare("SELECT idproducto, codbarras, vencimiento, cantidad, precio, stotal FROM det_ventas WHERE idventas = ?");
                $stmtDetVenta->bind_param("i", $idventas);
                $stmtDetVenta->execute();
                $resultDetVenta = $stmtDetVenta->get_result();

                while ($detVenta = $resultDetVenta->fetch_assoc()) {
                    $idproducto = $detVenta['idproducto'];
                    $codbarras = $detVenta['codbarras'];
                    $vencimiento = $detVenta['vencimiento'];
                    $cantidad = $detVenta['cantidad'];
                    $precio = $detVenta['precio'];
                    $stotal = $detVenta['stotal'];

                    // Insertar en el kardex
                    $stmtInsertKardex = $conn->prepare("INSERT INTO kardex (idproducto, codbarras, idlocal, idusuario, fecha, tipo, ingsal, cantidad, precio) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    $stmtInsertKardex->bind_param("isiisssdd", $idproducto, $codbarras, $idlocal, $idusuario, $fecha, $tipo, $ingsal, $cantidad, $precio);
                    $stmtInsertKardex->execute();
                    $stmtInsertKardex->close();

                    // Actualizar stock en el idlocal
                    $stmtStock = $conn->prepare("SELECT idstock, cantidad FROM stock WHERE idlocal = ? AND idproducto = ? AND barras = ?");
                    $stmtStock->bind_param("iis", $idlocal, $idproducto, $codbarras);
                    $stmtStock->execute();
                    $resultStock = $stmtStock->get_result();

                    if ($resultStock->num_rows > 0) {
                        // Producto existe en stock, actualizar cantidad
                        $stock = $resultStock->fetch_assoc();
                        $idstock = $stock['idstock'];
                        $nuevaCantidad = $stock['cantidad'] - $cantidad;

                        // Verificar que la cantidad no sea negativa
                        if ($nuevaCantidad < 0) {
                            echo json_encode(array("mensaje" => "No hay suficiente stock en el local."));
                            return;
                        }

                        $nuevoStotal = $nuevaCantidad * $precio;
                        $stmtUpdateStock = $conn->prepare("UPDATE stock SET cantidad = ?, stotal = ?  WHERE idstock = ?");
                        $stmtUpdateStock->bind_param("ddi", $nuevaCantidad, $nuevoStotal, $idstock);
                        $stmtUpdateStock->execute();
                        $stmtUpdateStock->close();
                    } else {
                        echo json_encode(array("mensaje" => "Producto no encontrado en stock."));
                        return;
                    }
                }
                $stmtDetVenta->close();

                echo "Venta cerrada y stock modificado exitosamente";
            } else {
                echo "Error al actualizar venta: " . $stmtUpdateVenta->error;
            }

            $stmtUpdateVenta->close();
        } else {
            echo json_encode(array("mensaje" => "Venta no encontrada."));
        }

        $stmtVenta->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function deleteVenta($conn, $id) {
    $sql = "DELETE FROM ventas WHERE idventas = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Venta eliminada exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar venta: " . $conn->error));
    }

    $stmt->close();
}

$conn->close();
?>
