<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteUsuario($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idu'])) {
            getUsuarioById($conn, $_GET['idu']);
        } 
        else {
            getUsuarios($conn);}
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateUsuario($conn);
                break;
            case 'agregar':
                createUsuario($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteUsuario($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getUsuarios($conn) {
    $sql = "SELECT 
    auser.*, 
    alocal.local as local
FROM 
    auser 
JOIN 
    alocal ON auser.idlocal = alocal.idlocal 
ORDER BY 
    auser.Idusuario DESC;";
    $result = $conn->query($sql);

    $usuarios = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $usuarios[] = $row;  
        }

        echo json_encode($usuarios);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron usuarios"));
    }
}

function getUsuarioById($conn, $id) {
    $sql = "SELECT `Idusuario`, `usuario`, `rol`, `estado`, `idlocal` FROM `auser` WHERE `usuario` = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
       echo json_encode(['existe' => true]);
    } else {
       echo json_encode(['existe usu' => false]);
    }

    $stmt->close();
}

function getUsuario($conn, $usuario) {
    $stmt = $conn->prepare("SELECT usuario FROM usuario WHERE usuario = ?");
    $stmt->bind_param("s", $usuario); 
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        echo json_encode(['existe' => true]);
    } else {
        echo json_encode(['existe usu' => false]);
    }
    $stmt->close();
}


function createUsuario($conn) {
    if (isset($_POST['usuario']) && isset($_POST['clave']) && isset($_POST['rol']) && isset($_POST['estado']) && isset($_POST['idlocal'])) {
        $usuario = TRIM($_POST['usuario']);
        $nombres = $_POST['nombres'];
        $clave = TRIM($_POST['clave']);
        $rol = $_POST['rol'];
        $estado = $_POST['estado'];
        $idlocal = $_POST['idlocal'];
        $llave = $_POST['llave'];
        $celular = $_POST['celular'];

        $sql = "INSERT INTO auser (usuario, nombres, clave, rol, estado, idlocal, llave, celular) 
                VALUES (?, ?, ?, ?, ?, ?, ?,?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssssisi", $usuario, $nombres, $clave, $rol, $estado, $idlocal, $llave, $celular);

        if ($stmt->execute()) {
            echo json_encode(['message' => 'Usuario creado exitosamente.']);
        } else {
            echo json_encode(array("mensaje" => "Error al crear usuario: " . $conn->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateUsuario($conn) {
    if (isset($_POST['Idusuario']) && isset($_POST['clave']) && isset($_POST['rol']) && isset($_POST['estado']) && isset($_POST['idlocal'])) {
        $Idusuario = $_POST['Idusuario'];
        $nombres = $_POST['nombres'];
        $clave = $_POST['clave'];
        $rol = $_POST['rol'];
        $estado = $_POST['estado'];
        $idlocal = $_POST['idlocal'];
        $celular = isset($_POST['celular']) ? $_POST['celular'] : null; // Manejo de celular opcional

        // Usar sentencias preparadas para evitar inyección SQL
        $stmt = $conn->prepare("UPDATE auser SET nombres=?, clave=?, rol=?, estado=?, idlocal=?, celular=? WHERE Idusuario=?");
        $stmt->bind_param("ssssiii", $nombres, $clave, $rol, $estado, $idlocal, $celular, $Idusuario);

        if ($stmt->execute()) {
            echo "Usuario actualizado exitosamente";
        } else {
            echo "Error al actualizar usuario: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function deleteUsuario($conn, $id) {
    // Verificar si el usuario está asignado en la tabla produccion
    $checkProduccionSql = "SELECT COUNT(*) FROM produccion WHERE idusuario = ?";
    $checkProduccionStmt = $conn->prepare($checkProduccionSql);
    $checkProduccionStmt->bind_param("i", $id);
    $checkProduccionStmt->execute();
    $checkProduccionStmt->bind_result($produccionCount);
    $checkProduccionStmt->fetch();
    $checkProduccionStmt->close();

    // Verificar si el usuario está asignado en la tabla traslado
    $checkTrasladoSql = "SELECT COUNT(*) FROM traslado WHERE idusuario = ?";
    $checkTrasladoStmt = $conn->prepare($checkTrasladoSql);
    $checkTrasladoStmt->bind_param("i", $id);
    $checkTrasladoStmt->execute();
    $checkTrasladoStmt->bind_result($trasladoCount);
    $checkTrasladoStmt->fetch();
    $checkTrasladoStmt->close();

    // Verificar si el usuario está asignado en la tabla ventas
    $checkVentasSql = "SELECT COUNT(*) FROM ventas WHERE idusuario = ?";
    $checkVentasStmt = $conn->prepare($checkVentasSql);
    $checkVentasStmt->bind_param("i", $id);
    $checkVentasStmt->execute();
    $checkVentasStmt->bind_result($ventasCount);
    $checkVentasStmt->fetch();
    $checkVentasStmt->close();

    // Comprobar si el usuario está asignado en alguna de las tablas
    if ($produccionCount > 0 || $trasladoCount > 0 || $ventasCount > 0) {
        // Si hay registros asociados, no se puede eliminar
        echo json_encode(array("mensaje" => "No se puede eliminar el usuario porque ya registro produccion, traslado o ventas"));
        return;
    }

    // Si no hay registros asociados, proceder a eliminar el usuario
    $sql = "DELETE FROM auser WHERE Idusuario = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Usuario eliminado exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar usuario: " . $conn->error));
    }

    $stmt->close();
}


$conn->close();
?>