<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteTraslado($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idtra'])) {
            getTrasladoById($conn, $_GET['idtra']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idu'])) {
            getTraslados($conn, $_GET['idu']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idlocal'])) {
            getRecepcion($conn, $_GET['idlocal']);
        } 
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateTraslado($conn);
                break;
            case 'agregar':
                createTraslado($conn);
                break;
            case 'cerrar':
                cerrarTraslado($conn);
                break;
            case 'recibir':
                cerrarRecibo($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteTraslado($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getTraslados($conn, $idu) {
    $sql = "SELECT 
        t.idtraslado, 
        t.idlocal, 
        t.idusuario, 
        t.fecha, 
        t.idlocal_d, 
        t.monto,
        t.estado,
        a.local AS destino
    FROM 
        traslado t
    JOIN 
        alocal a ON t.idlocal_d = a.idlocal
    WHERE
        t.idusuario = ?
    ORDER BY 
        t.idtraslado DESC;";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idu);
    $stmt->execute();
    $result = $stmt->get_result();

    $traslados = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $traslados[] = $row;  
        }

        echo json_encode($traslados);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron traslados"));
    }
}

function getRecepcion($conn, $idlocal) {
    $sql = "SELECT 
        t.idtraslado, 
        t.idlocal, 
        t.idusuario, 
        t.fecha, 
        t.idlocal_d, 
        t.monto,
        t.monto_r,
        t.estado,
        a.local AS destino
    FROM 
        traslado t
    JOIN 
        alocal a ON t.idlocal = a.idlocal
    WHERE
        t.idlocal_d = ? and t.estado != 'Abierto'
    ORDER BY 
        t.idtraslado DESC;";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idlocal);
    $stmt->execute();
    $result = $stmt->get_result();

    $traslados = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $traslados[] = $row;  
        }

        echo json_encode($traslados);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron traslados"));
    }
}

function getTrasladoById($conn, $idtra) {
    $sql = "
        SELECT 
            t.idtraslado, 
            t.idlocal, 
            t.idusuario, 
            t.fecha, 
            t.idlocal_d, 
            t.monto, 
            t.estado, 
            t.idusuario_r, 
            t.monto_r,
            a.local AS local, 
            u.usuario AS usuario,
            d.local AS destino
        FROM 
            traslado t
        JOIN 
            alocal a ON t.idlocal = a.idlocal
        JOIN 
            auser u ON t.idusuario = u.idusuario
        JOIN 
            alocal d ON t.idlocal_d = d.idlocal
        WHERE 
            t.idtraslado = ?
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idtra);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $traslado = [];
        while ($row = $result->fetch_assoc()) {
            $traslado[] = $row; // Agrega cada registro al array
        }
        echo json_encode($traslado);
    } else {
        echo json_encode(array("mensaje" => "No se encontró traslado"));
    }

    $stmt->close();
}


function createTraslado($conn) {
    if (isset($_POST['idlocal']) && isset($_POST['idusuario']) && isset($_POST['fecha']) && isset($_POST['idlocal_d']) && isset($_POST['estado'])) {
        $idlocal = $_POST['idlocal'];
        $idusuario = $_POST['idusuario'];
        $fecha = $_POST['fecha'];
        $idlocal_d = $_POST['idlocal_d'];
        $monto = $_POST['monto'];
        $estado = $_POST['estado'];

        // Verificar que idlocal_d no sea nulo o cero
        if ($idlocal_d === null || $idlocal_d == 0 || $idlocal_d === " ") {
            echo json_encode(array("mensaje" => "El idlocal_d no puede ser nulo o cero."));
        } else {
            $sql = "INSERT INTO traslado (idlocal, idusuario, fecha, idlocal_d, monto, estado) 
                    VALUES (?, ?, ?, ?, ?, ?)";
            $stmt = $conn->prepare($sql);
            $stmt->bind_param("iisids", $idlocal, $idusuario, $fecha, $idlocal_d, $monto, $estado);
            
            if ($stmt->execute()) {
                $idtraslado = $conn->insert_id;
                echo json_encode(['idtraslado' => $idtraslado]);
            } else {
                error_log($stmt->error); 
                echo json_encode(array("mensaje" => "Error al crear traslado: " . $stmt->error));
            }

            $stmt->close();
        }
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateTraslado($conn) {
    if (isset($_POST['idtraslado']) && isset($_POST['idlocal']) && isset($_POST['idusuario']) && isset($_POST['fecha']) && isset($_POST['idlocal_d']) && isset($_POST['estado'])) {
        $idtraslado = $_POST['idtraslado'];
        $idlocal = $_POST['idlocal'];
        $idusuario = $_POST['idusuario'];
        $fecha = $_POST['fecha'];
        $idlocal_d = $_POST['idlocal_d'];
        $monto = $_POST['monto'];
        $estado = $_POST['estado'];

        $stmt = $conn->prepare("UPDATE traslado SET idlocal=?, idusuario=?, fecha=?, idlocal_d=?, monto=?, estado=? WHERE idtraslado=?");
        $stmt->bind_param("iisidsi", $idlocal, $idusuario, $fecha, $idlocal_d, $monto, $estado, $idtraslado);

        if ($stmt->execute()) {
            echo "Traslado actualizado exitosamente";
        } else {
            echo "Error al actualizar traslado: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function cerrarTraslado($conn) {
    if (isset($_POST['idtraslado'])) {
        $idtraslado = $_POST['idtraslado'];

        // Obtener datos de la tabla traslado
        $stmtTraslado = $conn->prepare("SELECT idlocal, idusuario, fecha, idlocal_d, monto FROM traslado WHERE idtraslado = ?");
        $stmtTraslado->bind_param("i", $idtraslado);
        $stmtTraslado->execute();
        $resultTraslado = $stmtTraslado->get_result();

        if ($resultTraslado->num_rows > 0) {
            $traslado = $resultTraslado->fetch_assoc();
            $idlocalSalida = $traslado['idlocal'];
            $idlocalEntrada = $traslado['idlocal_d'];
            $fecha = $traslado['fecha'];
            $idusuario = $traslado['idusuario'];
            $monto = $traslado['monto']; // Obtener el monto

            // Verificar si el monto es 0
            if ($monto == 0) {
                echo json_encode(array("mensaje" => "No se puede cerrar el traslado, el monto es 0."));
                return; // Salir de la función
            }

            $tipo = "Traslado";
            $ingsal = "S"; // Salida

            // Actualizar el estado del traslado
            $stmtUpdateTraslado = $conn->prepare("UPDATE traslado SET estado=? WHERE idtraslado=?");
            $estado = "Enviado";
            $stmtUpdateTraslado->bind_param("si", $estado, $idtraslado);

            if ($stmtUpdateTraslado->execute()) {
                // Obtener detalles del traslado
                $stmtDetTraslado = $conn->prepare("SELECT idproducto, codbarras, vencimiento, cantidad, precio, stotal FROM det_traslado WHERE idtraslado = ?");
                $stmtDetTraslado->bind_param("i", $idtraslado);
                $stmtDetTraslado->execute();
                $resultDetTraslado = $stmtDetTraslado->get_result();

                while ($detTraslado = $resultDetTraslado->fetch_assoc()) {
                    $idproducto = $detTraslado['idproducto'];
                    $codbarras = $detTraslado['codbarras'];
                    $vencimiento = $detTraslado['vencimiento'];
                    $cantidad = $detTraslado['cantidad'];
                    $precio = $detTraslado['precio'];
                    $stotal = $detTraslado['stotal'];

                    // Insertar en el kardex
                    $stmtInsertKardex = $conn->prepare("INSERT INTO kardex (idproducto, codbarras, idlocal, idusuario, fecha, tipo, ingsal, cantidad, precio) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    $stmtInsertKardex->bind_param("isiisssdd", $idproducto, $codbarras, $idlocalSalida, $idusuario, $fecha, $tipo, $ingsal, $cantidad, $precio);
                    if (!$stmtInsertKardex->execute()) {
                        echo json_encode(array("mensaje" => "Error al insertar en kardex: " . $stmtInsertKardex->error));
                        return;
                    }
                    $stmtInsertKardex->close();

                    // Actualizar stock en el idlocal de salida
                    $stmtStockSalida = $conn->prepare("SELECT idstock, cantidad FROM stock WHERE idlocal = ? AND idproducto = ? AND barras = ?");
                    $stmtStockSalida->bind_param("iis", $idlocalSalida, $idproducto, $codbarras);
                    $stmtStockSalida->execute();
                    $resultStockSalida = $stmtStockSalida->get_result();

                    if ($resultStockSalida->num_rows > 0) {
                        // Producto existe en stock de salida, actualizar cantidad
                        $stockSalida = $resultStockSalida->fetch_assoc();
                        $idstockSalida = $stockSalida['idstock'];
                        $nuevaCantidadSalida = $stockSalida['cantidad'] - $cantidad;

                        // Verificar que la cantidad no sea negativa
                        if ($nuevaCantidadSalida < 0) {
                            echo json_encode(array("mensaje" => "No hay suficiente stock en el local de salida."));
                            return;
                        }

                        $nuevoStotal = $nuevaCantidadSalida * $precio;
                        $stmtUpdateStockSalida = $conn->prepare("UPDATE stock SET cantidad = ?, stotal = ? WHERE idstock = ?");
                        $stmtUpdateStockSalida->bind_param("ddi", $nuevaCantidadSalida, $nuevoStotal, $idstockSalida);
                        if (!$stmtUpdateStockSalida->execute()) {
                            echo json_encode(array("mensaje" => "Error al actualizar stock: " . $stmtUpdateStockSalida->error));
                            return;
                        }
                        $stmtUpdateStockSalida->close();
                    }
                }
                $stmtDetTraslado->close();

                echo json_encode(array("mensaje" => "Traslado actualizado y stock modificado exitosamente"));
            } else {
                echo json_encode(array("mensaje" => "Error al actualizar traslado: " . $stmtUpdateTraslado->error));
            }

            $stmtUpdateTraslado->close();
        } else {
            echo json_encode(array("mensaje" => "Traslado no encontrado."));
        }

        $stmtTraslado->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}


function cerrarRecibo($conn) {
    if (isset($_POST['idtraslado'])) {
        $idtraslado = $_POST['idtraslado'];
        $idusuario_r = $_POST['idusuario_r'];

        // Obtener datos de la tabla traslado
        $stmtTraslado = $conn->prepare("SELECT idlocal, idusuario, fecha, idlocal_d, monto FROM traslado WHERE idtraslado = ?");
        $stmtTraslado->bind_param("i", $idtraslado);
        $stmtTraslado->execute();
        $resultTraslado = $stmtTraslado->get_result();

        if ($resultTraslado->num_rows > 0) {
            $traslado = $resultTraslado->fetch_assoc();
            $idlocalSalida = $traslado['idlocal'];
            $idlocalEntrada = $traslado['idlocal_d'];
            $fecha = $traslado['fecha'];
            $idusuario = $traslado['idusuario'];
            $tipo = "Recibido";
            $ingsal = "I"; 

            // Actualizar el estado del traslado
            $stmtUpdateTraslado = $conn->prepare("UPDATE traslado SET estado=?, idusuario_r=? WHERE idtraslado=?");
            $estado = "Cerrado";
            $stmtUpdateTraslado->bind_param("sii", $estado, $idusuario_r, $idtraslado);

            if ($stmtUpdateTraslado->execute()) {
                // Obtener detalles del traslado
                $stmtDetTraslado = $conn->prepare("SELECT idproducto, codbarras, vencimiento, cantidad_r, precio_r, stotal_r FROM det_traslado WHERE idtraslado = ?");
                $stmtDetTraslado->bind_param("i", $idtraslado);
                $stmtDetTraslado->execute();
                $resultDetTraslado = $stmtDetTraslado->get_result();

                while ($detTraslado = $resultDetTraslado->fetch_assoc()) {
                    $idproducto = $detTraslado['idproducto'];
                    $codbarras = $detTraslado['codbarras'];
                    $vencimiento = $detTraslado['vencimiento'];
                    $cantidad = $detTraslado['cantidad_r'];
                    $precio = $detTraslado['precio_r'];
                    $stotal = $detTraslado['stotal_r'];

                    // Insertar en el kardex
                    $stmtInsertKardex = $conn->prepare("INSERT INTO kardex (idproducto, codbarras, idlocal, idusuario, fecha, tipo, ingsal, cantidad, precio) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    $stmtInsertKardex->bind_param("isiisssdd", $idproducto, $codbarras, $idlocalSalida, $idusuario, $fecha, $tipo, $ingsal, $cantidad, $precio);
                    $stmtInsertKardex->execute();
                    $stmtInsertKardex->close();

                    // Actualizar o insertar en el idlocal de entrada
                    $stmtStockEntrada = $conn->prepare("SELECT idstock, cantidad FROM stock WHERE idlocal = ? AND idproducto = ?");
                    $stmtStockEntrada->bind_param("ii", $idlocalEntrada, $idproducto);
                    $stmtStockEntrada->execute();
                    $resultStockEntrada = $stmtStockEntrada->get_result();

                    if ($resultStockEntrada->num_rows > 0) {
                         // Producto existe en stock
                        if ($codbarras != 0) {
                            // Código de barras diferente de cero, insertar como nuevo producto
                            $stmtInsertStock = $conn->prepare("INSERT INTO stock (idlocal, idproducto, barras, vencimiento, cantidad, precio, stotal) VALUES (?, ?, ?, ?, ?, ?, ?)");
                            $stmtInsertStock->bind_param("iissddd", $idlocalEntrada, $idproducto, $codbarras, $vencimiento, $cantidad, $precio, $stotal);
                            $stmtInsertStock->execute();
                            $stmtInsertStock->close();
                        } else {
                        // Código de barras es cero, actualizar cantidad, precio y stotal
                            $stockEntrada = $resultStockEntrada->fetch_assoc();
                            $idstockEntrada = $stockEntrada['idstock'];
                            $nuevaCantidadEntrada = $stockEntrada['cantidad'] + $cantidad;
                            $nuevoStotal = $nuevaCantidadEntrada * $precio;
    
                            $stmtUpdateStockEntrada = $conn->prepare("UPDATE stock SET cantidad = ?, stotal = ? WHERE idstock = ?");
                            $stmtUpdateStockEntrada->bind_param("ddi", $nuevaCantidadEntrada, $nuevoStotal, $idstockEntrada);
                            $stmtUpdateStockEntrada->execute();
                            $stmtUpdateStockEntrada->close();
                        }
                    } else {
                        // No existe el producto en stock de entrada, insertar nuevo
                        $stmtInsertStockEntrada = $conn->prepare("INSERT INTO stock (idlocal, idproducto, barras, vencimiento, cantidad, precio, stotal) VALUES (?, ?, ?, ?, ?, ?, ?)");
                        $stmtInsertStockEntrada->bind_param("iissddd", $idlocalEntrada, $idproducto, $codbarras, $vencimiento, $cantidad, $precio, $stotal);
                        $stmtInsertStockEntrada->execute();
                        $stmtInsertStockEntrada->close();
                    }
                    $stmtStockEntrada->close();
                }
                $stmtDetTraslado->close();

                echo "Traslado actualizado y stock modificado exitosamente";
            } else {
                echo "Error al actualizar traslado: " . $stmtUpdateTraslado->error;
            }

            $stmtUpdateTraslado->close();
        } else {
            echo json_encode(array("mensaje" => "Traslado no encontrado."));
        }

        $stmtTraslado->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function deleteTraslado($conn, $id) {
    $sql = "DELETE FROM traslado WHERE idtraslado = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Traslado eliminado exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar traslado: " . $conn->error));
    }

    $stmt->close();
}

$conn->close();
?>
