<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteProducto($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idp'])) {
            getProductoById($conn, $_GET['idp']);
        } 
        else {
            getProductos($conn);
        }
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateProducto($conn);
                break;
            case 'agregar':
                createProducto($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteProducto($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getProductos($conn) {
    $sql = "SELECT 
    *
    FROM 
    aproducto 
    ORDER BY 
    idproducto DESC;";
    $result = $conn->query($sql);

    $productos = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $productos[] = $row;  
        }

        echo json_encode($productos);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron productos"));
    }
}

function getProductoById($conn, $id) {
    $sql = "SELECT * FROM aproducto WHERE idproducto = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
       echo json_encode(['existe' => true, 'producto' => $result->fetch_assoc()]);
    } else {
       echo json_encode(['existe' => false]);
    }

    $stmt->close();
}

function createProducto($conn) {
    if (isset($_POST['producto']) && isset($_POST['codigo_barras']) && isset($_POST['categoria']) && isset($_POST['tipo']) && isset($_POST['precio_compra']) && isset($_POST['precio_venta']) && isset($_POST['unidad_medida']) && isset($_POST['estado'])) {
        $producto = TRIM($_POST['producto']);
        $codigo_barras = TRIM($_POST['codigo_barras']);
        $categoria = $_POST['categoria'];
        $tipo = $_POST['tipo'];
        $precio_compra = $_POST['precio_compra'];
        $precio_venta = $_POST['precio_venta'];
        //$stock = $_POST['stock'];
        $unidad_medida = $_POST['unidad_medida'];
        //$vencimiento = $_POST['vencimiento'];
        $estado = $_POST['estado'];
        

        $sql = "INSERT INTO aproducto (producto, codigo_barras, categoria, tipo, precio_compra, precio_venta, unidad_medida, estado) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssddss", $producto, $codigo_barras, $categoria, $tipo, $precio_compra, $precio_venta, $unidad_medida, $estado);

        if ($stmt->execute()) {
            echo json_encode(['message' => 'Producto creado exitosamente.']);
        } else {
            echo json_encode(array("mensaje" => "Error al crear producto: " . $conn->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateProducto($conn) {
    if (isset($_POST['idproducto']) && isset($_POST['producto']) && isset($_POST['codigo_barras']) && isset($_POST['categoria']) && isset($_POST['tipo']) && isset($_POST['precio_compra']) && isset($_POST['precio_venta']) && isset($_POST['unidad_medida']) && isset($_POST['estado'])) {
        $idproducto = $_POST['idproducto'];
        $producto = $_POST['producto'];
        $codigo_barras = isset($_POST['codigo_barras']) ? $_POST['codigo_barras'] : null;
        $categoria = $_POST['categoria'];
        $tipo = $_POST['tipo'];
        $precio_compra = $_POST['precio_compra'];
        $precio_venta = $_POST['precio_venta'];
        //$stock = $_POST['stock'];
        $unidad_medida = $_POST['unidad_medida'];
        //$vencimiento = $_POST['vencimiento'];
        $estado = $_POST['estado'];

        $stmt = $conn->prepare("UPDATE aproducto SET producto=?, codigo_barras=?, categoria=?, tipo=?, precio_compra=?, precio_venta=?, unidad_medida=?, estado=? WHERE idproducto=?");
        $stmt->bind_param("ssssddssi", $producto, $codigo_barras, $categoria, $tipo, $precio_compra, $precio_venta, $unidad_medida, $estado, $idproducto);

        if ($stmt->execute()) {
            echo "Producto actualizado exitosamente";
        } else {
            echo "Error al actualizar producto: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function deleteProducto($conn, $id) {
    // Verificar si el producto está registrado en la tabla det_produccion
    $checkSql = "SELECT COUNT(*) FROM det_produccion WHERE idproducto = ?";
    $checkStmt = $conn->prepare($checkSql);
    $checkStmt->bind_param("i", $id);
    $checkStmt->execute();
    $checkStmt->bind_result($detProduccionCount);
    $checkStmt->fetch();
    $checkStmt->close();

    if ($detProduccionCount > 0) {
        // Si hay registros en det_produccion, no se puede eliminar
        echo json_encode(array("mensaje" => "No se puede eliminar el producto porque ya está registrado en produccion"));
        return;
    }

    // Si no hay registros en det_produccion, proceder a eliminar el producto
    $sql = "DELETE FROM aproducto WHERE idproducto = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Producto eliminado exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar producto: " . $conn->error));
    }

    $stmt->close();
}


$conn->close();
?>