<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteLocal($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idlocal'])) {
            getLocalById($conn, $_GET['idlocal']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['localdestino'])) {
            getLocalDestino($conn, $_GET['localdestino']);
        }
        else {
            getLocales($conn);
        }
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateLocal($conn);
                break;
            case 'agregar':
                createLocal($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteLocal($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getLocalDestino($conn, $localdestino) {
    $sql = "SELECT * FROM `alocal` WHERE `idlocal` != ? ORDER BY `idlocal` DESC;";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $localdestino);
    $stmt->execute();
    $result = $stmt->get_result();

    $locales = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $locales[] = $row;  
        }

        echo json_encode($locales);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron locales"));
    }

    $stmt->close();
}


function getLocales($conn) {
    $sql = "SELECT * FROM `alocal` ORDER BY `idlocal` DESC;";
    $result = $conn->query($sql);

    $locales = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $locales[] = $row;  
        }

        echo json_encode($locales);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron locales"));
    }
}

function getLocalById($conn, $id) {
    $sql = "SELECT `idlocal`, `local`, `tipo`, `direccion`, `estado`, `aforo` FROM `alocal` WHERE `idlocal` = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode($row);
    } else {
        echo json_encode(array("mensaje" => "No se encontró el local"));
    }

    $stmt->close();
}

function createLocal($conn) {
    if (isset($_POST['local']) && isset($_POST['tipo']) && isset($_POST['direccion']) && isset($_POST['estado']) && isset($_POST['aforo'])) {
        $local = TRIM($_POST['local']);
        $tipo = TRIM($_POST['tipo']);
        $direccion = TRIM($_POST['direccion']);
        $estado = $_POST['estado'];
        $aforo = $_POST['aforo'];

        $sql = "INSERT INTO alocal (local, tipo, direccion, estado, aforo) 
                VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssi", $local, $tipo, $direccion, $estado, $aforo);

        if ($stmt->execute()) {
            echo json_encode(['message' => 'Local creado exitosamente.']);
        } else {
            echo json_encode(array("mensaje" => "Error al crear local: " . $conn->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateLocal($conn) {
    if (isset($_POST['idlocal']) && isset($_POST['local']) && isset($_POST['tipo']) && isset($_POST['direccion']) && isset($_POST['estado']) && isset($_POST['aforo'])) {
        $idlocal = $_POST['idlocal'];
        $local = TRIM($_POST['local']);
        $tipo = TRIM($_POST['tipo']);
        $direccion = TRIM($_POST['direccion']);
        $estado = $_POST['estado'];
        $aforo = $_POST['aforo'];

        $sql = "UPDATE alocal 
                SET local=?, tipo=?, direccion=?, estado=?, aforo=? 
                WHERE idlocal=?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssii", $local, $tipo, $direccion, $estado, $aforo, $idlocal);

        if ($stmt->execute()) {
            echo json_encode(array("mensaje" => "Local actualizado exitosamente."));
        } else {
            echo json_encode(array("mensaje" => "Error al actualizar local: " . $conn->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function deleteLocal($conn, $id) {
    // Verificar si el local está asignado a un usuario
    $checkSql = "SELECT COUNT(*) FROM auser WHERE idlocal = ?";
    $checkStmt = $conn->prepare($checkSql);
    $checkStmt->bind_param("i", $id);
    $checkStmt->execute();
    $checkStmt->bind_result($usuarioCount);
    $checkStmt->fetch();
    $checkStmt->close();

    if ($usuarioCount > 0) {
        // Si hay usuarios asignados, no se puede eliminar
        echo json_encode(array("mensaje" => "No se puede eliminar el local porque ya tiene usuarios."));
        return;
    }

    // Si no hay usuarios asignados, proceder a eliminar el local
    $sql = "DELETE FROM alocal WHERE idlocal = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Local eliminado exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar local: " . $conn->error));
    }

    $stmt->close();
}


$conn->close();
?>