<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['idlocal'])) {
            getProductos($conn, $_GET['idlocal']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idlocal_det'])) {
            getProductos_det($conn, $_GET['idlocal_det']);
        }
        elseif (isset($_GET['llave']) && isset($_GET['idlocal_cab'])) {
            getProductos_cab($conn, $_GET['idlocal_cab']);
        }
        elseif (isset($_GET['llave']) && isset($_GET['idstock'])) {
            getProductosCantidad($conn, $_GET['idstock']);
        } 
        else {
            getProductos1($conn);
        }
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateProducto($conn);
                break;
            case 'agregar':
                createProducto($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteProducto($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getProductos($conn, $idlocal) {
    $sql = "SELECT 
        s.idstock, 
        s.idlocal, 
        s.idproducto, 
        s.barras, 
        s.vencimiento,
        s.cantidad, 
        s.precio, 
        s.stotal,
        p.producto,
        p.codigo_barras
    FROM 
        stock s
    JOIN 
        aproducto p ON s.idproducto = p.idproducto
    WHERE 
        s.idlocal = ? AND s.cantidad > 0
    ORDER BY 
        p.producto ASC;";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idlocal);
    $stmt->execute();
    $result = $stmt->get_result();

    $productos = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $productos[] = $row;  
        }

        echo json_encode($productos);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron productos"));
    }

    $stmt->close();
}

function getProductos_det($conn, $idlocal) {
    $sql = "SELECT 
        s.idstock, 
        s.idlocal, 
        s.idproducto, 
        s.barras, 
        s.vencimiento,
        s.cantidad, 
        s.precio, 
        s.stotal,
        p.producto,
        p.categoria
    FROM 
        stock s
    JOIN 
        aproducto p ON s.idproducto = p.idproducto
    WHERE 
        s.idlocal = ? AND s.cantidad > 0
    ORDER BY 
        p.categoria ASC,
        p.producto ASC;";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idlocal);
    $stmt->execute();
    $result = $stmt->get_result();

    $productos = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $productos[] = $row;  
        }

        echo json_encode($productos);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron productos"));
    }

    $stmt->close();
}

function getProductos_cab($conn, $idlocal) {
    $sql = "SELECT 
        l.local, 
        SUM(s.stotal) AS total_stotal  -- Sumar el stotal
    FROM 
        stock s
    JOIN 
        alocal l ON s.idlocal = l.idlocal  -- Unir con la tabla alocal
    WHERE 
        s.idlocal = ? AND s.cantidad > 0
    GROUP BY 
        l.local  -- Agrupar por el campo local
    ORDER BY 
        l.local ASC;";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idlocal);  
    $stmt->execute();
    $result = $stmt->get_result();

    $resumen = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $resumen[] = $row;  
        }

        echo json_encode($resumen);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron productos"));
    }

    $stmt->close();
}


function getProductosCantidad($conn, $idstock) {
    $sql = "SELECT 
        cantidad
    FROM 
        stock
    WHERE 
        idstock = ? "; 

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idstock); 
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode(array("cantidad" => $row['cantidad']));
    } else {
        echo json_encode(array("mensaje" => "No se encontraron productos"));
    }

    $stmt->close();
}


function createProducto($conn) {
    if (isset($_POST['producto']) && isset($_POST['codigo_barras']) && isset($_POST['categoria']) && isset($_POST['tipo']) && isset($_POST['precio_compra']) && isset($_POST['precio_venta']) && isset($_POST['stock']) && isset($_POST['unidad_medida']) && isset($_POST['vencimiento']) && isset($_POST['estado'])) {
        $producto = TRIM($_POST['producto']);
        $codigo_barras = TRIM($_POST['codigo_barras']);
        $categoria = $_POST['categoria'];
        $tipo = $_POST['tipo'];
        $precio_compra = $_POST['precio_compra'];
        $precio_venta = $_POST['precio_venta'];
        $stock = $_POST['stock'];
        $unidad_medida = $_POST['unidad_medida'];
        $vencimiento = $_POST['vencimiento'];
        $estado = $_POST['estado'];
        

        $sql = "INSERT INTO aproducto (producto, codigo_barras, categoria, tipo, precio_compra, precio_venta, stock, unidad_medida, vencimiento, estado) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssdddsss", $producto, $codigo_barras, $categoria, $tipo, $precio_compra, $precio_venta, $stock, $unidad_medida, $vencimiento, $estado);

        if ($stmt->execute()) {
            echo json_encode(['message' => 'Producto creado exitosamente.']);
        } else {
            echo json_encode(array("mensaje" => "Error al crear producto: " . $conn->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateProducto($conn) {
    if (isset($_POST['idproducto']) && isset($_POST['producto']) && isset($_POST['codigo_barras']) && isset($_POST['categoria']) && isset($_POST['tipo']) && isset($_POST['precio_compra']) && isset($_POST['precio_venta']) && isset($_POST['stock']) && isset($_POST['unidad_medida']) && isset($_POST['vencimiento']) && isset($_POST['estado'])) {
        $idproducto = $_POST['idproducto'];
        $producto = $_POST['producto'];
        $codigo_barras = isset($_POST['codigo_barras']) ? $_POST['codigo_barras'] : null;
        $categoria = $_POST['categoria'];
        $tipo = $_POST['tipo'];
        $precio_compra = $_POST['precio_compra'];
        $precio_venta = $_POST['precio_venta'];
        $stock = $_POST['stock'];
        $unidad_medida = $_POST['unidad_medida'];
        $vencimiento = $_POST['vencimiento'];
        $estado = $_POST['estado'];

        $stmt = $conn->prepare("UPDATE aproducto SET producto=?, codigo_barras=?, categoria=?, tipo=?, precio_compra=?, precio_venta=?, stock=?, unidad_medida=?, vencimiento=?, estado=? WHERE idproducto=?");
        $stmt->bind_param("ssssdddsssi", $producto, $codigo_barras, $categoria, $tipo, $precio_compra, $precio_venta, $stock, $unidad_medida, $vencimiento, $estado, $idproducto);

        if ($stmt->execute()) {
            echo "Producto actualizado exitosamente";
        } else {
            echo "Error al actualizar producto: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function deleteProducto($conn, $id) {
    $sql = "DELETE FROM aproducto WHERE idproducto = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Producto eliminado exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar producto: " . $conn->error));
    }

    $stmt->close();
}

$conn->close();
?>