<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

switch ($method) {
    case 'GET':
        if (isset($_GET['idu'])) {
            getUsuarioById($conn, $_GET['idu']);
        }
        elseif (isset($_GET['idu1'])) {
            getUsuarioById1($conn, $_GET['idu1']);
        }
        elseif (isset($_GET['usuario'])) {
            getUsuario($conn, $_GET['usuario']);
        }  
        elseif (isset($_GET['miembro'])) {
            getMiembro($conn, $_GET['miembro']);
        }  
        elseif (isset($_GET['cdl'])) {
            getUsuariocdl($conn, $_GET['cdl']);
        } 
         elseif (isset($_GET['cdp'])) {
            getUsuariocdp($conn, $_GET['cdp']);
        } 
        else { 
            getUsuarios($conn);
        }
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateUsuario($conn);
                break;
            case 'editar1':
                updateUsuario1($conn);
                break;
            case 'agregar1':
                createUsuario1($conn);
                break;
            case 'agregar':
                createUsuario($conn);
                break;
            case 'login':
                loginUsuario($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['id']) && isset($_GET['rol']) && isset($_GET['usuglobal'])) {
            deleteUsuariox($conn, $_GET['id'], $_GET['rol'], $_GET['usuglobal']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getUsuario($conn, $usuario) {
    $stmt = $conn->prepare("SELECT usuario FROM usuario WHERE usuario = ?");
    $stmt->bind_param("s", $usuario); 
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        echo json_encode(['existe' => true]);
    } else {
        echo json_encode(['existe usu' => false]);
    }
    $stmt->close();
}

function getMiembro($conn, $miembro) {
    
    $sql = "SELECT miembros.miembro, miembros.idcongregacion, congregacion.iglesia FROM miembros, congregacion WHERE miembros.idcongregacion = congregacion.idcongregacion and  dni = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $miembro);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        echo json_encode(['existe' => true, 'miembro' => $row['miembro'], 'idcongregacion' => $row['idcongregacion'], 'congregacion' => $row['iglesia']]);
    } else {
        echo json_encode(['existe miem' => false]);
    }
    
    $stmt->close();
    $conn->close();
}

function getUsuariocdl($conn, $cdl) {
    $sql = "SELECT usuario.idusuario, usuario.idmiembro, usuario.correo, usuario.usuario, usuario.clave, usuario.celular, 
    usuario.rol, usuario.estado, usuario.nombresap, usuario.tipo, usuario.idcongregacion, congregacion.idconsejo, congregacion.iglesia FROM usuario, congregacion 
    where usuario.idcongregacion = congregacion.idcongregacion and usuario.idcongregacion = $cdl;";
    $result = $conn->query($sql);

    $usuarios = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $usuarios[] = $row;  
        }

        echo json_encode($usuarios);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron usuarios"));
    }
}

function getUsuariocdp($conn, $cdp) {
    $sql = "SELECT usuario.idusuario, usuario.idmiembro, usuario.correo, usuario.usuario, usuario.clave, usuario.celular, 
    usuario.rol, usuario.estado, usuario.nombresap, usuario.tipo, usuario.idcongregacion, congregacion.idconsejo, congregacion.iglesia FROM usuario, congregacion 
    where usuario.idcongregacion = congregacion.idcongregacion
   and congregacion.idconsejo = $cdp and usuario.tipo != 'MIEMBRO';";
    $result = $conn->query($sql);

    $usuarios = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $usuarios[] = $row;  
        }

        echo json_encode($usuarios);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron usuarios"));
    }
}

// Función para obtener todos los usuarios
function getUsuarios($conn) {
    $sql = "SELECT usuario.idusuario, usuario.idmiembro, usuario.correo, usuario.usuario, usuario.clave, usuario.celular, 
    usuario.rol, usuario.estado, usuario.nombresap, usuario.tipo, usuario.idcongregacion, congregacion.idconsejo, congregacion.iglesia FROM usuario, congregacion 
    where usuario.idcongregacion = congregacion.idcongregacion ORDER BY idusuario DESC;";
    $result = $conn->query($sql);

    $usuarios = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $usuarios[] = $row;  
        }

        echo json_encode($usuarios);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron usuarios"));
    }
}

function getUsuarioById($conn, $id) {
    $sql = "SELECT * FROM `usuario` where `usuario`.`idusuario` = $id";
    $result = $conn->query($sql);

    $usuarios = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $usuarios[] = $row;  
        }

        echo json_encode($usuarios);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron usuarios"));
    }
}
// Función para obtener un usuario por su ID
function getUsuarioById1($conn, $idu1) {
    $sql = "SELECT usuario.idusuario, usuario.idmiembro, usuario.correo, usuario.usuario, usuario.clave, usuario.celular, usuario.rol, usuario.estado, usuario.usu, 
            usuario.idcongregacion, usuario.nombresap, usuario.tipo, congregacion.iglesia 
            FROM usuario, congregacion WHERE usuario.idcongregacion = congregacion.idcongregacion and usuario.idusuario = $idu1";
    $result = $conn->query($sql);

    $usuarios = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $usuarios[] = $row;  
        }

        echo json_encode($usuarios);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron usuarios"));
    }
}

// Función para crear un nuevo usuario
function createUsuario($conn) {
    if (isset($_POST['correo']) && isset($_POST['usuario']) && isset($_POST['clave']) && isset($_POST['celular']) && isset($_POST['rol']) && isset($_POST['estado'])) {
        $idmiembro = '2025';
        $correo = $_POST['correo'];
        $usuario = TRIM($_POST['usuario']);
        $clave = TRIM($_POST['clave']);
        $celular = $_POST['celular'];
        $rol = $_POST['rol'];
        $estado = $_POST['estado'];

        // Usar declaraciones preparadas para evitar inyecciones SQL
        $stmt = $conn->prepare("INSERT INTO usuario (idmiembro, correo, usuario, clave, celular, rol, estado) VALUES (?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("issssss", $idmiembro, $correo, $usuario, $clave, $celular, $rol, $estado);

        if ($stmt->execute()) {
            $idusuario = $conn->insert_id; 
            $usu = $usuario;
            $update_stmt = $conn->prepare("UPDATE usuario SET usu = ? WHERE idusuario = ?");
            $update_stmt->bind_param("si", $usu, $idusuario);
            
            if ($update_stmt->execute()) {
                // Inserción en seguimiento
                $inser_stmt = $conn->prepare("INSERT INTO seguimiento (idusuario, idplan, fecha, aprobado) VALUES (?, '1', NOW(), '0')");
                $inser_stmt->bind_param("i", $idusuario);
                
                if ($inser_stmt->execute()) {
                    echo json_encode(['usu' => $usu, 'message' => 'Usuario creado exitosamente y campo "usu" actualizado.']);
                } else {
                    echo json_encode(['error' => 'Error al insertar en seguimiento: ' . $conn->error]);
                }
            } else {
                echo json_encode(['error' => 'Error al actualizar el campo "usu": ' . $conn->error]);
            }
        } else {
            echo json_encode(['error' => 'Error al crear usuario: ' . $conn->error]);
        }

        $stmt->close();
        $update_stmt->close();
        $inser_stmt->close();
    } else {
        echo json_encode(['error' => 'Faltan parámetros.']);
    }
}

function createUsuario1($conn) {
    
    if (!isset($_POST['correo'], $_POST['usuario'], $_POST['clave'], $_POST['idcongregacion'], $_POST['rol'], $_POST['estado'])) {
        echo json_encode(['message' => 'Faltan parámetros.']);
        return;
    }

    $idcongregacion = $_POST['idcongregacion'];
    $tipo = $_POST['tipo'] ?? null; // Usar null si no está definido
    $nombresap = strtoupper(trim($_POST['nombresap'] ?? ''));
    $correo = trim($_POST['correo']);
    $usuario = trim($_POST['usuario']);
    $clave = trim($_POST['clave']);
    $celular = trim($_POST['celular']);
    $rol = $_POST['rol'];
    $estado = $_POST['estado'];
    $rolglobal = $_POST['rolglobal'];
    $usuglobal = $_POST['usuglobal'];

    if ($rolglobal === 'CDL') {
        $vacantes_stmt = $conn->prepare("SELECT vacantes FROM congregacion WHERE idcongregacion = ?");
        $vacantes_stmt->bind_param("i", $idcongregacion);
        $vacantes_stmt->execute();
        $vacantes_stmt->bind_result($vacantes);
        $vacantes_stmt->fetch();
        $vacantes_stmt->close();

        $usuarios_stmt = $conn->prepare("SELECT COUNT(*) FROM usuario WHERE idcongregacion = ? and tipo = 'MIEMBRO'");
        $usuarios_stmt->bind_param("i", $idcongregacion);
        $usuarios_stmt->execute();
        $usuarios_stmt->bind_result($num_usuarios);
        $usuarios_stmt->fetch();
        $usuarios_stmt->close();

        if ($vacantes < $num_usuarios) {
            echo json_encode(['message' => 'No hay vacantes disponibles en esta congregación.']);
            return;
        }
    }

    $stmt = $conn->prepare("INSERT INTO usuario (idcongregacion, correo, usuario, clave, celular, rol, estado, tipo, nombresap) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("issssssss", $idcongregacion, $correo, $usuario, $clave, $celular, $rol, $estado, $tipo, $nombresap);

    if ($stmt->execute()) {
        $idusuario = $stmt->insert_id; 

        $inser_stmt = $conn->prepare("INSERT INTO seguimiento (idusuario, idplan, fecha, aprobado) VALUES (?, '1', NOW(), '0')");
        $inser_stmt->bind_param("i", $idusuario);
        $inser_stmt->execute();
        $inser_stmt->close();
        
        $accion = $rolglobal . '-insertar';
        $inser1_stmt = $conn->prepare("INSERT INTO bitacora (accion, dni, usuario, fechahora) VALUES (?, ?, ?,NOW())");
        $inser1_stmt->bind_param("sss", $accion, $usuario, $usuglobal);
        $inser1_stmt->execute();
        $inser1_stmt->close();

        echo json_encode(['usu' => $usuario, 'message' => 'Usuario creado exitosamente']);
    } else {
        echo json_encode(['error' => 'Error al crear usuario: ' . $conn->error]);
    }

    $stmt->close();
}

// Función para actualizar un usuario
function updateUsuario1($conn) {
    if (isset($_POST['idusuario']) && isset($_POST['correo']) && isset($_POST['usuario']) && isset($_POST['clave']) && isset($_POST['rol']) && isset($_POST['estado'])) {
        $idusuario = $_POST['idusuario'];
        $correo = $_POST['correo'];
        $usuario = TRIM($_POST['usuario']);
        $clave = TRIM($_POST['clave']);
        $celular = $_POST['celular'];
        $rol = $_POST['rol'];
        $estado = $_POST['estado'];
        $idcongregacion = $_POST['idcongregacion'];
        $tipo = $_POST['tipo'];
        $nombresap = strtoupper(trim($_POST['nombresap'] ?? ''));
        $rolglobal = $_POST['rolglobal'];
        $usuglobal = $_POST['usuglobal'];
        
        $sql = "UPDATE usuario 
                SET correo='$correo', usuario='$usuario', clave='$clave', celular='$celular', rol='$rol', estado='$estado',
                idcongregacion=$idcongregacion, tipo = '$tipo', nombresap = '$nombresap'
                WHERE idusuario=$idusuario";

        if ($conn->query($sql) === TRUE) {
            echo "Usuario actualizado exitosamente";
        } else {
            echo "Error al actualizar usuario: " . $conn->error;
        }
    } else {
        echo "Faltan parámetros.";
    }
}

function updateUsuario($conn) {
    if (isset($_POST['idusuario']) && isset($_POST['correo']) && isset($_POST['usuario']) && isset($_POST['clave']) && isset($_POST['celular']) && isset($_POST['rol']) && isset($_POST['estado'])) {
        $idusuario = $_POST['idusuario'];
        
        $correo = $_POST['correo'];
        $usuario = TRIM($_POST['usuario']);
        $clave = TRIM($_POST['clave']);
        $celular = $_POST['celular'];
        $rol = $_POST['rol'];
        $estado = $_POST['estado'];
        
        $sql = "UPDATE usuario 
                SET correo='$correo', usuario='$usuario', clave='$clave', celular='$celular', rol='$rol', estado='$estado' 
                WHERE idusuario=$idusuario";

        if ($conn->query($sql) === TRUE) {
            echo "Usuario actualizado exitosamente";
        } else {
            echo "Error al actualizar usuario: " . $conn->error;
        }
    } else {
        echo "Faltan parámetros.";
    }
}

// Función para eliminar un usuario
function deleteUsuariox($conn, $id, $rol, $usuglobal ) {
    $stmtx = $conn->prepare("SELECT count(idseguimiento) as canti FROM seguimiento WHERE idusuario = ?");
    $stmtx->bind_param("i", $id);
    $stmtx->execute();
    $result1 = $stmtx->get_result();
    $row1 = $result1->fetch_assoc();

    if ($result1 && $row1['canti'] > 1) {
        echo json_encode(['usu' => $id, 'message' => 'Usuario tiene lecturas, no se puede eliminar']);
        return;
    }
    
    $sqlCheck = "SELECT tipo, usuario FROM usuario WHERE idusuario = $id";
    $result = $conn->query($sqlCheck);
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $tipoUsuario = $row['tipo'];
        $dni = $row['usuario'];
        }

    switch ($rol) {
        case 'CDN':
            $sql1 = "DELETE FROM seguimiento WHERE idusuario = $id";
            if ($conn->query($sql1) === TRUE) {
                    $sql = "DELETE FROM usuario WHERE idusuario = $id";
                    if ($conn->query($sql) === TRUE) {
                        echo json_encode(['usu' => $id, 'message' => 'Usuario eliminado exitosamente']);
                        $accion = $rol . '-borrar';
                        $inser1_stmt = $conn->prepare("INSERT INTO bitacora (accion, dni,usuario, fechahora) VALUES (?, ?,?, NOW())");
                        $inser1_stmt->bind_param("sss", $accion, $dni, $usuglobal);
                        $inser1_stmt->execute();
                        $inser1_stmt->close();
                    } 
                } 
            break;
    
        case 'CDP':
            if ($tipoUsuario != 'MIEMBRO') {
            $sql1 = "DELETE FROM seguimiento WHERE idusuario = $id";
            if ($conn->query($sql1) === TRUE) {
                    $sql = "DELETE FROM usuario WHERE idusuario = $id";
                    if ($conn->query($sql) === TRUE) {
                        echo json_encode(['usu' => $id, 'message' => 'Usuario eliminado exitosamente']);
                        $accion = $rol . '-borrar';
                        $inser1_stmt = $conn->prepare("INSERT INTO bitacora (accion, dni,usuario, fechahora) VALUES (?, ?,?, NOW())");
                        $inser1_stmt->bind_param("sss", $accion, $dni, $usuglobal);
                        $inser1_stmt->execute();
                        $inser1_stmt->close();
                    } 
                }
            }else{ echo json_encode(['usu' => $id, 'message' => 'No puedes eliminar Miembros']);}
            break;
    
        case 'CDL':
            if ($tipoUsuario == 'MIEMBRO') {
                $sql1 = "DELETE FROM seguimiento WHERE idusuario = $id";
            if ($conn->query($sql1) === TRUE) {
                    $sql = "DELETE FROM usuario WHERE idusuario = $id";
                    if ($conn->query($sql) === TRUE) {
                        echo json_encode(['usu' => $id, 'message' => 'Usuario eliminado exitosamente']);
                        $accion = $rol . '-borrar';
                        $inser1_stmt = $conn->prepare("INSERT INTO bitacora (accion, dni,usuario, fechahora) VALUES (?, ?,?, NOW())");
                        $inser1_stmt->bind_param("sss", $accion, $dni, $usuglobal);
                        $inser1_stmt->execute();
                        $inser1_stmt->close();
                    } 
                }
            }else{ echo json_encode(['usu' => $id, 'message' => 'No puedes eliminar Ministro ni Pastor']);}
            break;
    
        default:
            echo "Método no permitido";
            break;
    }

}

function deleteUsuario($conn, $id, $rol) {
    // Usar sentencias preparadas para evitar inyección SQL
    $stmt = $conn->prepare("SELECT count(idseguimiento) as canti FROM seguimiento WHERE idusuario = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result1 = $stmt->get_result();
    $row1 = $result1->fetch_assoc();

    if ($result1 && $row1['canti'] > 1) {
        echo json_encode(['usu' => $id, 'message' => 'Usuario tiene lecturas, no se puede eliminar']);
        return;
    }

    $stmt = $conn->prepare("SELECT tipo FROM usuario WHERE idusuario = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $tipoUsuario = $row['tipo'];

        if ($rol === 'CDL' && $tipoUsuario !== 'MIEMBRO') {
            echo json_encode(['usu' => $id, 'message' => 'No se puede eliminar el usuario: solo se puede eliminar a usuarios de tipo "MIEMBRO" con rol "CDL".']);
            return; 
        }

        if ($rol === 'CDP' || $rol === 'CDN') {
            $stmt = $conn->prepare("DELETE FROM seguimiento WHERE idusuario = ?");
            $stmt->bind_param("i", $id);
            if ($stmt->execute()) {
                $stmt = $conn->prepare("DELETE FROM usuario WHERE idusuario = ?");
                $stmt->bind_param("i", $id);
                if ($stmt->execute()) {
                    echo json_encode(['usu' => $id, 'message' => 'Usuario eliminado exitosamente']);
                } else {
                    echo json_encode(['usu' => $id, 'message' => 'Error al eliminar usuario: ' . $conn->error]);
                }
            } else {
                echo json_encode(['usu' => $id, 'message' => 'Error al eliminar seguimiento: ' . $conn->error]);
            }
            return; 
        }

        echo json_encode(['usu' => $id, 'message' => 'No se puede eliminar el usuario: rol no permitido.']);
    } else {
        echo json_encode(['usu' => $id, 'message' => 'Usuario no encontrado.']);
    }
}


function loginUsuario($conn) {
    $usuario = $_POST['usuario'];
    $clave = $_POST['clave'];
        
    $sql = "SELECT * FROM `auser` where `usuario` = '$usuario' and `clave` = '$clave';";
    $result = $conn->query($sql);

    $usuarios = array();  // Creamos un array para almacenar los usuarios

    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $usuarios[] = $row;  // Añadimos el usuario al array
        }

        // Convertimos el array de usuarios en formato JSON y lo enviamos al cliente
        echo json_encode($usuarios);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron usuarios"));
    }
}

$conn->close();


?>
