<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteProduccion($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idpro'])) {
            getProduccionById($conn, $_GET['idpro']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idu'])) {
            getProducciones($conn, $_GET['idu']);
        } 
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateProduccion($conn);
                break;
            case 'agregar':
                createProduccion($conn);
                break;
            case 'cerrar':
                cerrarProduccion($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteProduccion($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getProducciones($conn, $idu) {
    $sql = "SELECT 
    idproduccion, 
    idlocal, 
    idusuario, 
    fecha, 
    turno, 
    monto, 
    estado 
    FROM 
    produccion 
    WHERE
    idusuario = $idu
    ORDER BY 
    idproduccion DESC;";
    $result = $conn->query($sql);

    $producciones = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $producciones[] = $row;  
        }

        echo json_encode($producciones);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron producciones"));
    }
}

function getProduccionById($conn, $idpro) {
    $sql = "
        SELECT 
            p.idproduccion, 
            p.idlocal, 
            p.idusuario, 
            p.fecha, 
            p.turno, 
            p.monto, 
            p.estado, 
            a.local AS local, 
            u.usuario AS usuario
        FROM 
            produccion p
        JOIN 
            alocal a ON p.idlocal = a.idlocal
        JOIN 
            auser u ON p.idusuario = u.idusuario
        WHERE 
            p.idproduccion = ?
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idpro);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $produccion = [];
        while ($row = $result->fetch_assoc()) {
            $produccion[] = $row; // Agrega cada registro al array
        }
        echo json_encode($produccion);
    } else {
        echo json_encode(array("mensaje" => "No se encontró producción"));
    }

    $stmt->close();
}


function createProduccion($conn) {
    if (isset($_POST['idlocal']) && isset($_POST['idusuario']) && isset($_POST['fecha']) && isset($_POST['turno']) && isset($_POST['monto']) && isset($_POST['estado'])) {
        $idlocal = $_POST['idlocal'];
        $idusuario = $_POST['idusuario'];
        $fecha = $_POST['fecha'];
        $turno = $_POST['turno'];
        $monto = $_POST['monto'];
        $estado = $_POST['estado'];

        $sql = "INSERT INTO produccion (idlocal, idusuario, fecha, turno, monto, estado) 
                VALUES (?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iissds", $idlocal, $idusuario, $fecha, $turno, $monto, $estado);
        
        if ($stmt->execute()) {
            $idproduccion = $conn->insert_id;
            echo json_encode(['idproduccion' => $idproduccion]);
        } else {
            error_log($stmt->error); 
            echo json_encode(array("mensaje" => "Error al crear producción: " . $stmt->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateProduccion($conn) {
    if (isset($_POST['idproduccion']) && isset($_POST['idlocal']) && isset($_POST['idusuario']) && isset($_POST['fecha']) && isset($_POST['turno']) && isset($_POST['monto']) && isset($_POST['estado'])) {
        $idproduccion = $_POST['idproduccion'];
        $idlocal = $_POST['idlocal'];
        $idusuario = $_POST['idusuario'];
        $fecha = $_POST['fecha'];
        $turno = $_POST['turno'];
        $monto = $_POST['monto'];
        $estado = $_POST['estado'];

        $stmt = $conn->prepare("UPDATE produccion SET idlocal=?, idusuario=?, fecha=?, turno=?, monto=?, estado=? WHERE idproduccion=?");
        $stmt->bind_param("iissdsi", $idlocal, $idusuario, $fecha, $turno, $monto, $estado, $idproduccion);

        if ($stmt->execute()) {
            echo "Producción actualizada exitosamente";
        } else {
            echo "Error al actualizar producción: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function cerrarProduccion($conn) {
    if (isset($_POST['idproduccion'])) {
        $idproduccion = $_POST['idproduccion'];

        // Obtener datos de la tabla produccion
        $stmtProduccion = $conn->prepare("SELECT idlocal, idusuario, fecha, turno, monto FROM produccion WHERE idproduccion = ?");
        $stmtProduccion->bind_param("i", $idproduccion);
        $stmtProduccion->execute();
        $resultProduccion = $stmtProduccion->get_result();

        if ($resultProduccion->num_rows > 0) {
            $produccion = $resultProduccion->fetch_assoc();
            $idlocal = $produccion['idlocal'];
            $fecha = $produccion['fecha'];
            $idusuario = $produccion['idusuario'];
            $tipo = "Produccion";
            $ingsal = "I";

            // Actualizar el estado de la producción
            $stmtUpdateProduccion = $conn->prepare("UPDATE produccion SET estado=? WHERE idproduccion=?");
            $estado = "Cerrado";
            $stmtUpdateProduccion->bind_param("si", $estado, $idproduccion);

            if ($stmtUpdateProduccion->execute()) {
                // Obtener detalles de la producción
                $stmtDetProduccion = $conn->prepare("SELECT idproducto, codbarras, vencimiento, cantidad, precio, stotal FROM det_produccion WHERE idproduccion = ?");
                $stmtDetProduccion->bind_param("i", $idproduccion);
                $stmtDetProduccion->execute();
                $resultDetProduccion = $stmtDetProduccion->get_result();

                while ($detProduccion = $resultDetProduccion->fetch_assoc()) {
                    $idproducto = $detProduccion['idproducto'];
                    $codbarras = $detProduccion['codbarras'];
                    $vencimiento = $detProduccion['vencimiento'];
                    $cantidad = $detProduccion['cantidad'];
                    $precio = $detProduccion['precio'];
                    $stotal = $detProduccion['stotal'];
                    
                    $stmtInsertKardex = $conn->prepare("INSERT INTO kardex (idproducto, codbarras, idlocal, idusuario, fecha, tipo, ingsal, cantidad, precio) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    $stmtInsertKardex->bind_param("isiisssdd", $idproducto, $codbarras, $idlocal, $idusuario, $fecha, $tipo, $ingsal, $cantidad, $precio);
                    $stmtInsertKardex->execute();
                    $stmtInsertKardex->close();

                    // Verificar si el producto ya existe en stock
                    $stmtStock = $conn->prepare("SELECT idstock, cantidad FROM stock WHERE idlocal = ? AND idproducto = ?");
                    $stmtStock->bind_param("ii", $idlocal, $idproducto);
                    $stmtStock->execute();
                    $resultStock = $stmtStock->get_result();

                    if ($resultStock->num_rows > 0) {
                        // Producto existe en stock
                        if ($codbarras != 0) {
                            // Código de barras diferente de cero, insertar como nuevo producto
                            $stmtInsertStock = $conn->prepare("INSERT INTO stock (idlocal, idproducto, barras, vencimiento, cantidad, precio, stotal) VALUES (?, ?, ?, ?, ?, ?, ?)");
                            $stmtInsertStock->bind_param("iissddd", $idlocal, $idproducto, $codbarras, $vencimiento, $cantidad, $precio, $stotal);
                            $stmtInsertStock->execute();
                            $stmtInsertStock->close();
                        } else {
                            // Código de barras es cero, actualizar cantidad, precio y stotal
                            $stock = $resultStock->fetch_assoc();
                            $idstock = $stock['idstock'];
                            $nuevaCantidad = $stock['cantidad'] + $cantidad;
                            $nuevoStotal = $nuevaCantidad * $precio;

                            $stmtUpdateStock = $conn->prepare("UPDATE stock SET cantidad = ?, precio = ?, stotal = ? WHERE idstock = ?");
                            $stmtUpdateStock->bind_param("dddi", $nuevaCantidad, $precio, $nuevoStotal, $idstock);
                            $stmtUpdateStock->execute();
                            $stmtUpdateStock->close();
                        }
                    } else {
                        // No existe el producto en stock, insertar nuevo
                        $stmtInsertStock = $conn->prepare("INSERT INTO stock (idlocal, idproducto, barras, vencimiento, cantidad, precio, stotal) VALUES (?, ?, ?, ?, ?, ?, ?)");
                        $stmtInsertStock->bind_param("iissddd", $idlocal, $idproducto, $codbarras, $vencimiento, $cantidad, $precio, $stotal);
                        $stmtInsertStock->execute();
                        $stmtInsertStock->close();
                    }
                    $stmtStock->close();
                
                   
                }
                $stmtDetProduccion->close();

                echo "Producción actualizada y stock modificado exitosamente";
            } else {
                echo "Error al actualizar producción: " . $stmtUpdateProduccion->error;
            }

            $stmtUpdateProduccion->close();
        } else {
            echo json_encode(array("mensaje" => "Producción no encontrada."));
        }

        $stmtProduccion->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}


function deleteProduccion($conn, $id) {
    $sql = "DELETE FROM produccion WHERE idproduccion = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Producción eliminada exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar producción: " . $conn->error));
    }

    $stmt->close();
}

$conn->close();
?>