<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteDetVenta($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idventas'])) {
            getDetVentaById($conn, $_GET['idventas']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idventa'])) {
            getDetVentas($conn, $_GET['idventa']);
        } 
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateDetVenta($conn);
                break;
            case 'agregar':
                createDetVenta($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteDetVenta($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getDetVentas($conn, $idventa) {
    $sql = "SELECT 
        dv.iddetventas, 
        dv.idventas, 
        dv.idproducto, 
        dv.idstock,
        dv.codbarras, 
        dv.vencimiento,
        dv.cantidad, 
        dv.precio, 
        dv.stotal,
        ap.producto,
        ap.codigo_barras,
        ap.categoria,
        ap.tipo,
        ap.precio_compra,
        ap.precio_venta,
        ap.stock,
        ap.unidad_medida,
        ap.vencimiento,
        ap.estado
    FROM 
        det_ventas dv
    JOIN 
        aproducto ap ON dv.idproducto = ap.idproducto
    WHERE
        dv.idventas = ?
    ORDER BY 
        dv.iddetventas DESC;";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idventa);
    $stmt->execute();
    $result = $stmt->get_result();

    $detVentas = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $detVentas[] = $row;  
        }

        echo json_encode($detVentas);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron detalles de venta"));
    }

    $stmt->close();
}

function getDetVentaById($conn, $idventas) {
    $sql = "
        SELECT 
            dv.*, 
            a.producto AS producto 
        FROM 
            det_ventas dv
        JOIN 
            aproducto a ON dv.idproducto = a.idproducto
        WHERE 
            dv.idventas = ?
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idventas);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $det_ventas = [];
        while ($row = $result->fetch_assoc()) {
            $det_ventas[] = $row; // Agrega cada registro al array
        }
        echo json_encode($det_ventas);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron detalles de la venta"));
    }

    $stmt->close();
}


function createDetVenta($conn) {
    if (isset($_POST['idventas']) && isset($_POST['idproducto']) && isset($_POST['cantidad']) && isset($_POST['precio']) && isset($_POST['stotal'])) {
        $idventas = $_POST['idventas'];
        $idproducto = $_POST['idproducto'];
        $codbarras = isset($_POST['codbarras']) && trim($_POST['codbarras']) !== '' ? $_POST['codbarras'] : 0;
        $vencimiento = isset($_POST['vencimiento']) ? $_POST['vencimiento'] : null;
        $cantidad = $_POST['cantidad'];
        $precio = $_POST['precio'];
        $stotal = $_POST['stotal'];
        $idstock = $_POST['idstock'];

        $sql = "INSERT INTO det_ventas (idventas, idstock, idproducto, codbarras, vencimiento, cantidad, precio, stotal) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        
        $stmt->bind_param("iiissddd", $idventas, $idstock, $idproducto, $codbarras, $vencimiento, $cantidad, $precio, $stotal);
        
        if ($stmt->execute()) {
            $iddetventas = $conn->insert_id;
            echo json_encode(['iddetventas' => $iddetventas]);
        } else {
            echo json_encode(array("mensaje" => "Error al crear detalle de venta: " . $stmt->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateDetVenta($conn) {
    if (isset($_POST['iddetventas']) && isset($_POST['idventas']) && isset($_POST['idproducto']) && isset($_POST['codbarras']) && isset($_POST['cantidad']) && isset($_POST['precio']) && isset($_POST['stotal'])) {
        $iddetventas = $_POST['iddetventas'];
        $idventas = $_POST['idventas'];
        $idproducto = $_POST['idproducto'];
        $codbarras = isset($_POST['codbarras']) && trim($_POST['codbarras']) !== '' ? $_POST['codbarras'] : 0;
        $vencimiento = isset($_POST['vencimiento']) ? $_POST['vencimiento'] : null;
        $cantidad = $_POST['cantidad'];
        $precio = $_POST['precio'];
        $stotal = $_POST['stotal'];
        $idstock = $_POST['idstock'];

        $stmt = $conn->prepare("UPDATE det_ventas SET idventas=?, idstock =?, idproducto=?, codbarras=?, vencimiento=?, cantidad=?, precio=?, stotal=? WHERE iddetventas=?");
        $stmt->bind_param("iiissdddi", $idventas, $idstock, $idproducto, $codbarras, $vencimiento, $cantidad, $precio, $stotal, $iddetventas);

        if ($stmt->execute()) {
            echo json_encode(['iddetventas' => $iddetventas]);
        } else {
            echo "Error al actualizar detalle de venta: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function deleteDetVenta($conn, $id) {
    $sql = "DELETE FROM det_ventas WHERE iddetventas = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Detalle de venta eliminado exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar detalle de venta: " . $conn->error));
    }

    $stmt->close();
}

$conn->close();
?>
