<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteDetTraslado($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idtra'])) {
            getDetTrasladoById($conn, $_GET['idtra']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idtraslado'])) {
            getDetTraslados($conn, $_GET['idtraslado']);
        } 
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateDetTraslado($conn);
                break;
            case 'recibir':
                recibirDetTraslado($conn);
                break;
            case 'agregar':
                createDetTraslado($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteDetTraslado($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getDetTraslados($conn, $idtraslado) {
    $sql = "SELECT 
        dt.iddettraslado, 
        dt.idtraslado, 
        dt.idstock,
        dt.idproducto, 
        dt.codbarras, 
        dt.vencimiento,
        dt.cantidad, 
        dt.precio, 
        dt.stotal,
        dt.cantidad_r, 
        dt.precio_r, 
        dt.stotal_r,
        ap.producto,
        ap.codigo_barras,
        ap.categoria,
        ap.tipo,
        ap.precio_compra,
        ap.precio_venta,
        ap.stock,
        ap.unidad_medida,
        ap.vencimiento,
        ap.estado
    FROM 
        det_traslado dt
    JOIN 
        aproducto ap ON dt.idproducto = ap.idproducto
    WHERE
        dt.idtraslado = ?
    ORDER BY 
        dt.iddettraslado DESC;";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idtraslado);
    $stmt->execute();
    $result = $stmt->get_result();

    $detTraslados = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $detTraslados[] = $row;  
        }

        echo json_encode($detTraslados);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron detalles de traslado"));
    }

    $stmt->close();
}

function getDetTrasladoById($conn, $idtra) {
    $sql = "
        SELECT 
            dt.*, 
            a.producto AS producto, 
            (dt.cantidad - dt.cantidad_r) AS diferencia
        FROM 
            det_traslado dt
        JOIN 
            aproducto a ON dt.idproducto = a.idproducto
        WHERE 
            dt.idtraslado = ?
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idtra);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $det_produccion = [];
        while ($row = $result->fetch_assoc()) {
            $det_produccion[] = $row; // Agrega cada registro al array
        }
        echo json_encode($det_produccion);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron detalles de la producción"));
    }

    $stmt->close();
}

function createDetTraslado($conn) {
    if (isset($_POST['idtraslado']) && isset($_POST['idproducto']) && isset($_POST['cantidad']) && isset($_POST['precio']) && isset($_POST['stotal'])) {
        $idtraslado = $_POST['idtraslado'];
        $idproducto = $_POST['idproducto'];
        $codbarras = isset($_POST['codbarras']) && trim($_POST['codbarras']) !== '' ? $_POST['codbarras'] : 0;
        $vencimiento = isset($_POST['vencimiento']) ? $_POST['vencimiento'] : null;
        $cantidad = $_POST['cantidad'];
        $precio = $_POST['precio'];
        $stotal = $_POST['stotal'];
        $idstock = $_POST['idstock'];

        $sql = "INSERT INTO det_traslado (idtraslado, idstock, idproducto, codbarras, vencimiento, cantidad, precio, stotal, cantidad_r, precio_r, stotal_r) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        
        $stmt->bind_param("iiissdddddd", $idtraslado, $idstock, $idproducto, $codbarras, $vencimiento, $cantidad, $precio, $stotal, $cantidad, $precio, $stotal);
        
        if ($stmt->execute()) {
            $iddettraslado = $conn->insert_id;
            echo json_encode(['iddettraslado' => $iddettraslado]);
        } else {
            echo json_encode(array("mensaje" => "Error al crear detalle de traslado: " . $stmt->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateDetTraslado($conn) {
    if (isset($_POST['iddettraslado']) && isset($_POST['idtraslado']) && isset($_POST['idproducto']) && isset($_POST['codbarras']) && isset($_POST['cantidad']) && isset($_POST['precio']) && isset($_POST['stotal'])) {
        $iddettraslado = $_POST['iddettraslado'];
        $idtraslado = $_POST['idtraslado'];
        $idproducto = $_POST['idproducto'];
        $codbarras = isset($_POST['codbarras']) && trim($_POST['codbarras']) !== '' ? $_POST['codbarras'] : 0;
        $vencimiento = isset($_POST['vencimiento']) ? $_POST['vencimiento'] : null;
        $cantidad = $_POST['cantidad'];
        $precio = $_POST['precio'];
        $stotal = $_POST['stotal'];
        $idstock = $_POST['idstock'];

        $stmt = $conn->prepare("UPDATE det_traslado SET idtraslado=?, idstock =?, idproducto=?, codbarras=?, vencimiento=?, cantidad=?, precio=?, stotal=?, cantidad_r=?, precio_r=?, stotal_r=? WHERE iddettraslado=?");
        $stmt->bind_param("iiissddddddi", $idtraslado, $idstock, $idproducto, $codbarras, $vencimiento, $cantidad, $precio, $stotal, $cantidad, $precio, $stotal, $iddettraslado);

        if ($stmt->execute()) {
            echo json_encode(['iddettraslado' => $iddettraslado]);
        } else {
            echo "Error al actualizar detalle de traslado: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function recibirDetTraslado($conn) {
    if (isset($_POST['iddettraslado']) ) {
        $iddettraslado = $_POST['iddettraslado'];
        $cantidad_r = $_POST['cantidad_r'];
        $precio_r = $_POST['precio_r'];
        $stotal_r = $_POST['stotal_r'];

        $stmt = $conn->prepare("UPDATE det_traslado SET cantidad_r=?, precio_r=?, stotal_r=? WHERE iddettraslado=?");
        $stmt->bind_param("dddi", $cantidad_r, $precio_r, $stotal_r, $iddettraslado);

        if ($stmt->execute()) {
            echo json_encode(['iddettraslado' => $iddettraslado]);
        } else {
            echo "Error al actualizar detalle de traslado: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}


function deleteDetTraslado($conn, $id) {
    $sql = "DELETE FROM det_traslado WHERE iddettraslado = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Detalle de traslado eliminado exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar detalle de traslado: " . $conn->error));
    }

    $stmt->close();
}

$conn->close();
?>
