<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteDetProduccion($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idpro'])) {
            getDetProduccionById($conn, $_GET['idpro']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idp'])) {
            getDetProducciones($conn, $_GET['idp']);
        } 
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateDetProduccion($conn);
                break;
            case 'agregar':
                createDetProduccion($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteDetProduccion($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}


function getDetProducciones($conn, $idp) {
    $sql = "SELECT 
        dp.iddetproduccion, 
        dp.idproduccion, 
        dp.idproducto, 
        dp.codbarras, 
        dp.vencimiento,
        dp.cantidad, 
        dp.precio, 
        dp.stotal,
        ap.producto,
        ap.codigo_barras,
        ap.categoria,
        ap.tipo,
        ap.precio_compra,
        ap.precio_venta,
        ap.stock,
        ap.unidad_medida,
        ap.estado
    FROM 
        det_produccion dp
    JOIN 
        aproducto ap ON dp.idproducto = ap.idproducto
    WHERE
        dp.idproduccion = ?
    ORDER BY 
        dp.iddetproduccion DESC;";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idp);
    $stmt->execute();
    $result = $stmt->get_result();

    $detProducciones = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $detProducciones[] = $row;  
        }

        echo json_encode($detProducciones);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron detalles de producción"));
    }

    $stmt->close();
}

function getDetProduccionById($conn, $idpro) {
    $sql = "
        SELECT 
            dp.*, 
            a.producto AS producto 
        FROM 
            det_produccion dp
        JOIN 
            aproducto a ON dp.idproducto = a.idproducto
        WHERE 
            dp.idproduccion = ?
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $idpro);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $det_produccion = [];
        while ($row = $result->fetch_assoc()) {
            $det_produccion[] = $row; // Agrega cada registro al array
        }
        echo json_encode($det_produccion);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron detalles de la producción"));
    }

    $stmt->close();
}


function createDetProduccion($conn) {
    if (isset($_POST['idproduccion']) && isset($_POST['idproducto']) && isset($_POST['cantidad']) && isset($_POST['precio']) && isset($_POST['stotal'])) {
        $idproduccion = $_POST['idproduccion'];
        $idproducto = $_POST['idproducto'];
        $codbarras = isset($_POST['codbarras']) && trim($_POST['codbarras']) !== '' ? $_POST['codbarras'] : 0;
        $vencimiento = isset($_POST['vencimiento']) ? $_POST['vencimiento'] : null;
        $cantidad = $_POST['cantidad'];
        $precio = $_POST['precio'];
        $stotal = $_POST['stotal'];

        $sql = "INSERT INTO det_produccion (idproduccion, idproducto, codbarras, vencimiento, cantidad, precio, stotal) 
                VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        
        // Corregir el nombre de la función
        $stmt->bind_param("iissddd", $idproduccion, $idproducto, $codbarras, $vencimiento, $cantidad, $precio, $stotal);
        
        if ($stmt->execute()) {
            $iddetproduccion = $conn->insert_id;
            echo json_encode(['iddetproduccion' => $iddetproduccion]);
        } else {
            echo json_encode(array("mensaje" => "Error al crear detalle de producción: " . $stmt->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}


function updateDetProduccion($conn) {
    if (isset($_POST['iddetproduccion']) && isset($_POST['idproduccion']) && isset($_POST['idproducto']) && isset($_POST['codbarras']) && isset($_POST['cantidad']) && isset($_POST['precio']) && isset($_POST['stotal'])) {
        $iddetproduccion = $_POST['iddetproduccion'];
        $idproduccion = $_POST['idproduccion'];
        $idproducto = $_POST['idproducto'];
        $codbarras = isset($_POST['codbarras']) && trim($_POST['codbarras']) !== '' ? $_POST['codbarras'] : 0;
        $vencimiento = isset($_POST['vencimiento']) ? $_POST['vencimiento'] : null;
        $cantidad = $_POST['cantidad'];
        $precio = $_POST['precio'];
        $stotal = $_POST['stotal'];

        $stmt = $conn->prepare("UPDATE det_produccion SET idproduccion=?, idproducto=?, codbarras=?, vencimiento=?, cantidad=?, precio=?, stotal=? WHERE iddetproduccion=?");
        $stmt->bind_param("iissdddi", $idproduccion, $idproducto, $codbarras, $vencimiento, $cantidad, $precio, $stotal, $iddetproduccion);

        if ($stmt->execute()) {
            echo json_encode(['iddetproduccion' => $iddetproduccion]);
           
        } else {
            echo "Error al actualizar detalle de producción: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function deleteDetProduccion($conn, $id) {
    $sql = "DELETE FROM det_produccion WHERE iddetproduccion = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Detalle de producción eliminado exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar detalle de producción: " . $conn->error));
    }

    $stmt->close();
}

$conn->close();
?>