<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteCliente($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idc'])) {
            getClienteById($conn, $_GET['idc']);
        } 
        else {
            getClientes($conn);
        }
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateCliente($conn);
                break;
            case 'agregar':
                createCliente($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteCliente($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getClientes($conn) {
    $sql = "SELECT 
        idcliente, 
        tipodoc, 
        doc, 
        razon, 
        direccion, 
        celular 
    FROM 
        cliente 
    ORDER BY 
        idcliente DESC;";
    
    $result = $conn->query($sql);

    $clientes = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $clientes[] = $row;  
        }

        echo json_encode($clientes);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron clientes"));
    }
}

function getClienteById($conn, $id) {
    $sql = "SELECT * FROM cliente WHERE idcliente = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
       echo json_encode(['existe' => true, 'cliente' => $result->fetch_assoc()]);
    } else {
       echo json_encode(['existe' => false]);
    }

    $stmt->close();
}

function createCliente($conn) {
    if (isset($_POST['tipodoc']) && isset($_POST['doc']) && isset($_POST['razon']) && isset($_POST['direccion']) && isset($_POST['celular'])) {
        $tipodoc = TRIM($_POST['tipodoc']);
        $doc = TRIM($_POST['doc']);
        $razon = TRIM($_POST['razon']);
        $direccion = TRIM($_POST['direccion']);
        $celular = TRIM($_POST['celular']);

        $sql = "INSERT INTO cliente (tipodoc, doc, razon, direccion, celular) 
                VALUES (?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("ssssi", $tipodoc, $doc, $razon, $direccion, $celular);

        if ($stmt->execute()) {
            echo json_encode(['message' => 'Cliente creado exitosamente.']);
        } else {
            echo json_encode(array("mensaje" => "Error al crear cliente: " . $conn->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateCliente($conn) {
    if (isset($_POST['idcliente']) && isset($_POST['tipodoc']) && isset($_POST['doc']) && isset($_POST['razon']) && isset($_POST['direccion']) && isset($_POST['celular'])) {
        $idcliente = $_POST['idcliente'];
        $tipodoc = $_POST['tipodoc'];
        $doc = $_POST['doc'];
        $razon = $_POST['razon'];
        $direccion = $_POST['direccion'];
        $celular = $_POST['celular'];

        $stmt = $conn->prepare("UPDATE cliente SET tipodoc=?, doc=?, razon=?, direccion=?, celular=? WHERE idcliente=?");
        $stmt->bind_param("ssssii", $tipodoc, $doc, $razon, $direccion, $celular, $idcliente);

        if ($stmt->execute()) {
            echo json_encode(array("mensaje" => "Cliente actualizado exitosamente."));
        } else {
            echo json_encode(array("mensaje" => "Error al actualizar cliente: " . $conn->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function deleteCliente($conn, $id) {
    // Verificar si el cliente tiene ventas asignadas
    $checkSql = "SELECT COUNT(*) FROM ventas WHERE idcliente = ?";
    $checkStmt = $conn->prepare($checkSql);
    $checkStmt->bind_param("i", $id);
    $checkStmt->execute();
    $checkStmt->bind_result($ventaCount);
    $checkStmt->fetch();
    $checkStmt->close();

    if ($ventaCount > 0) {
        // Si hay ventas asociadas, no se puede eliminar
        echo json_encode(array("mensaje" => "No se puede eliminar el cliente porque ya tiene ventas asignadas."));
        return;
    }

    // Si no hay ventas, proceder a eliminar el cliente
    $sql = "DELETE FROM cliente WHERE idcliente = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(array("mensaje" => "Cliente eliminado exitosamente."));
    } else {
        echo json_encode(array("mensaje" => "Error al eliminar cliente: " . $conn->error));
    }

    $stmt->close();
}


$conn->close();
?>
