<?php
include 'sdb.php';

$method = $_SERVER['REQUEST_METHOD'];

if (!isset($_GET['llave']) && !isset($_POST['llave'])) {
    echo json_encode(['error' => 'No tienes permiso para acceder a esta función.']);
    exit; 
}

$llave = isset($_GET['llave']) ? $_GET['llave'] : $_POST['llave'];

if (!esLlaveValida($conn, $llave)) {
    echo json_encode(['error' => 'Llave no válida.']);
    exit; 
}

function esLlaveValida($conn, $llave) {
    $sql = "SELECT COUNT(*) as count FROM auser WHERE llave = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $llave);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    return $row['count'] > 0; 
}

switch ($method) {
    case 'GET':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteCaja($conn, $_GET['id']);
        } 
        elseif (isset($_GET['llave']) && isset($_GET['idc'])) {
            getCajaById($conn, $_GET['idc']);
        }
        elseif (isset($_GET['llave']) && isset($_GET['idlocal']) && isset($_GET['idusuario'])) {
            getCajas($conn, $_GET['idlocal'], $_GET['idusuario']);
        }
        elseif (isset($_GET['llave']) && isset($_GET['idlocal']) && isset($_GET['fecha'])) {
            getRepCajas($conn, $_GET['idlocal'], $_GET['fecha']);
        }
        elseif (isset($_GET['llave']) && isset($_GET['idlocalcab']) && isset($_GET['fecha'])) {
            getRepCajas_cab($conn, $_GET['idlocalcab'], $_GET['fecha']);
        }
        else {
            getCajas1($conn);
        }
        break;

    case 'POST':
        switch ($_POST['foco']) {
            case 'editar':
                updateCaja($conn);
                break;
            case 'agregar':
                createCaja($conn);
                break;
            case 'cerrar':
                cerrarCaja($conn);
                break;
        }
        break;

    case 'DELETE':
        if (isset($_GET['llave']) && isset($_GET['id'])) {
            deleteCaja($conn, $_GET['id']);
        }
        break;

    default:
        echo "Método no permitido";
        break;
}

function getRepCajas_cab($conn, $idlocal, $fecha) {
    $sql = "SELECT 
        l.local AS local, 
        sUM(c.saldo_ini + c.efectivo) AS liquido,
        sUM(c.total) AS total
    FROM 
        caja c
    JOIN 
        alocal l ON c.idlocal = l.idlocal
    WHERE 
        c.idlocal = ? AND DATE(c.fecha_ini) = ?
        group by l.local
    ORDER BY 
c.idcaja DESC;";

    // Preparar la consulta
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("is", $idlocal, $fecha);
    $stmt->execute();
    $result = $stmt->get_result();

    $cajas = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $cajas[] = $row;  
        }
        echo json_encode($cajas);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron cajas"));
    }

    $stmt->close();
}


function getRepCajas($conn, $idlocal, $fecha) {
    $sql = "SELECT 
        c.idcaja, 
        c.idlocal, 
        c.idusuario, 
        c.turno, 
        TIME(c.fecha_ini) AS hora_ini,
        c.saldo_ini, 
        c.estado, 
        TIME(c.fecha_cierre) AS hora_cierre,
        c.efectivo, 
        c.yape, 
        c.plin, 
        c.deposito, 
        c.otros, 
        c.total,
        u.usuario AS usuario
    FROM 
        caja c
    LEFT JOIN 
        auser u ON c.idusuario = u.idusuario  -- Unión con tabla de usuarios
    WHERE 
        c.idlocal = ? AND DATE(c.fecha_ini) = ?
    ORDER BY c.idcaja DESC;
";

    // Preparar la consulta
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("is", $idlocal, $fecha);
    $stmt->execute();
    $result = $stmt->get_result();

    $cajas = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $cajas[] = $row;  
        }
        echo json_encode($cajas);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron cajas"));
    }

    $stmt->close();
}

function getCajas($conn, $idlocal, $idusuario) {
    $sql = "SELECT 
        idcaja, 
        idlocal, 
        idusuario, 
        turno, 
        fecha_ini, 
        saldo_ini, 
        estado, 
        fecha_cierre, 
        efectivo, 
        yape, 
        plin, 
        deposito, 
        otros, 
        total 
    FROM 
        caja 
    WHERE 
        idlocal = ? AND idusuario = ? AND DATE(fecha_ini) = CURDATE()
    ORDER BY 
        idcaja DESC;";

    // Preparar la consulta
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ii", $idlocal, $idusuario);
    $stmt->execute();
    $result = $stmt->get_result();

    $cajas = array();  
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $cajas[] = $row;  
        }
        echo json_encode($cajas);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron cajas"));
    }

    $stmt->close();
}


function getCajaById($conn, $id) {
    $sql = "SELECT 
    ca.idcaja, 
    ca.idlocal, 
    ca.idusuario, 
    ca.turno, 
    ca.fecha_ini, 
    ca.saldo_ini, 
    ca.estado, 
    ca.fecha_cierre, 
    ca.efectivo, 
    ca.yape, 
    ca.plin, 
    ca.deposito, 
    ca.otros, 
    ca.total,
    a.local AS local,
    u.usuario AS usuario,
    (ca.saldo_ini + ca.efectivo) AS liquido
FROM 
    caja ca
JOIN 
    alocal a ON ca.idlocal = a.idlocal
JOIN 
    auser u ON ca.idusuario = u.idusuario
WHERE 
    ca.idcaja = ? 
";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $caja = [];
        while ($row = $result->fetch_assoc()) {
            $caja[] = $row; 
        }
        echo json_encode($caja);
    } else {
        echo json_encode(array("mensaje" => "No se encontraron caja"));
    }

    $stmt->close();
}

function createCaja($conn) {
    if (isset($_POST['idlocal']) && isset($_POST['idusuario']) && isset($_POST['turno']) && isset($_POST['fecha_ini']) && isset($_POST['saldo_ini']) && isset($_POST['estado'])) {
        $idlocal = TRIM($_POST['idlocal']);
        $idusuario = TRIM($_POST['idusuario']);
        $turno = TRIM($_POST['turno']);
        $fecha_ini = TRIM($_POST['fecha_ini']);
        $saldo_ini = TRIM($_POST['saldo_ini']);
        $estado = TRIM($_POST['estado']);
        $efectivo = isset($_POST['efectivo']) ? TRIM($_POST['efectivo']) : 0;
        $yape = isset($_POST['yape']) ? TRIM($_POST['yape']) : 0;
        $plin = isset($_POST['plin']) ? TRIM($_POST['plin']) : 0;
        $deposito = isset($_POST['deposito']) ? TRIM($_POST['deposito']) : 0;
        $otros = isset($_POST['otros']) ? TRIM($_POST['otros']) : 0;
        $total = $efectivo + $yape + $plin + $deposito + $otros;

        $sql = "INSERT INTO caja (idlocal, idusuario, turno, fecha_ini, saldo_ini, estado, efectivo, yape, plin, deposito, otros, total) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("iissdsdddddd", $idlocal, $idusuario, $turno, $fecha_ini, $saldo_ini, $estado, $efectivo, $yape, $plin, $deposito, $otros, $total);
        
        if ($stmt->execute()) {
            $idcaja = $conn->insert_id;
            echo json_encode(['idcaja' => $idcaja]);
        }else {
            echo json_encode(array("mensaje" => "Error al crear caja: " . $conn->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function updateCaja($conn) {
    if (isset($_POST['idcaja']) ) {
        $idcaja = $_POST['idcaja'];
        $turno = $_POST['turno'];
        $saldo_ini = $_POST['saldo_ini'];
        $stmt = $conn->prepare("UPDATE caja SET turno=?, saldo_ini=? WHERE idcaja=?");
        $stmt->bind_param("sdi", $turno, $saldo_ini, $idcaja);

        if ($stmt->execute()) {
            echo json_encode(array("mensaje" => "Caja actualizada exitosamente."));
        } else {
            echo json_encode(array("mensaje" => "Error al actualizar caja: " . $conn->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function cerrarCaja($conn) {
    if (isset($_POST['idcaja']) ) {
        $idcaja = $_POST['idcaja'];
        $estado = $_POST['estado'];
       
        $stmt = $conn->prepare("UPDATE caja SET estado=?, fecha_cierre=NOW() WHERE idcaja=?");
        $stmt->bind_param("si", $estado, $idcaja);

        if ($stmt->execute()) {
            echo json_encode(array("mensaje" => "Caja actualizada exitosamente."));
        } else {
            echo json_encode(array("mensaje" => "Error al actualizar caja: " . $conn->error));
        }

        $stmt->close();
    } else {
        echo json_encode(array("mensaje" => "Faltan parámetros."));
    }
}

function deleteCaja($conn, $id) {
    // Primero, verificar si existen registros en la tabla ventas con el idcaja proporcionado
    $sql_check = "SELECT COUNT(*) FROM ventas WHERE idcaja = ?";
    $stmt_check = $conn->prepare($sql_check);
    $stmt_check->bind_param("i", $id);
    $stmt_check->execute();
    $stmt_check->bind_result($count);
    $stmt_check->fetch();
    $stmt_check->close();

    if ($count > 0) {
        // Si existen registros en ventas, no permitir la eliminación
        echo json_encode(array("mensaje" => "No se puede eliminar la caja porque existen ventas asociadas."));
    } else {
        // Si no existen registros en ventas, proceder con la eliminación de la caja
        $sql = "DELETE FROM caja WHERE idcaja = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $id);

        if ($stmt->execute()) {
            echo json_encode(array("mensaje" => "Caja eliminada exitosamente."));
        } else {
            echo json_encode(array("mensaje" => "Error al eliminar caja: " . $conn->error));
        }

        $stmt->close();
    }
}

$conn->close();
?>
